/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.RulesManager;
import org.netbeans.modules.java.hints.spiimpl.options.Bundle;
import org.netbeans.modules.java.hints.spiimpl.options.DepScanningSettings;
import org.netbeans.modules.java.hints.spiimpl.options.HintsPanelLogic;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Configuration;
import org.netbeans.modules.java.hints.spiimpl.refactoring.ConfigurationRenderer;
import org.netbeans.modules.java.hints.spiimpl.refactoring.ConfigurationsComboModel;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Utilities;
import org.netbeans.modules.options.editor.spi.OptionsFilter;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.Hint;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class HintsPanel
extends JPanel {
    private static final String DELETE = "delete";
    private static final String DECLARATIVE_HINT_TEMPLATE_LOCATION = "org-netbeans-modules-java-hints/templates/Inspection.hint";
    static final String[] EXTRA_NODE_KEYWORDS = new String[]{"CTL_DepScanning", "CTL_Scope_Desc", "CTL_Scope_Label"};
    private static final RequestProcessor WORKER = new RequestProcessor(HintsPanel.class.getName(), 1, false, false);
    private HintsPanelLogic logic;
    private DefaultTreeModel errorTreeModel;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Utilities.ClassPathBasedHintWrapper cpBased;
    private final QueryStatus queryStatus;
    private final boolean showHeavyInspections;
    private final RequestProcessor.Task expandTask = WORKER.create(new Runnable(){

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTree tree = HintsPanel.this.errorTree;
                    for (int r = 0; r < tree.getRowCount(); ++r) {
                        tree.expandRow(r);
                    }
                }
            });
        }
    });
    private HintMetadata toSelect = null;
    DefaultMutableTreeNode extraNode = new DefaultMutableTreeNode(NbBundle.getMessage(HintsPanel.class, (String)"CTL_DepScanning"));
    private boolean hasNewHints;
    private boolean confirmed;
    private OptionsFilter optionsFilter;
    private String customHintCodeBeforeEditing;
    private boolean wasModified;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JButton cancelEdit;
    private JComboBox configCombo;
    private JLabel configLabel;
    private JPanel configurationsPanel;
    private JPanel customizerPanel;
    private JLabel descriptionLabel;
    private JPanel descriptionPanel;
    private JScrollPane descriptionScrollPane;
    private JEditorPane descriptionTextArea;
    private JPanel detailsPanel;
    private JButton editScriptButton;
    private JPanel editingButtons;
    private JTree errorTree;
    private JButton exportButton;
    private JButton importButton;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JButton newButton;
    private JButton okButton;
    private JButton openInEditor;
    private JPanel optionsPanel;
    private JLabel refactoringsLabel;
    private JButton saveButton;
    private JScrollPane scriptScrollPane;
    private JEditorPane scriptTextArea;
    private JLabel searchLabel;
    private JPanel searchPanel;
    private JTextField searchTextField;
    private JComboBox severityComboBox;
    private JLabel severityLabel;
    private JCheckBox toProblemCheckBox;
    private JPanel treePanel;
    private final Map<HintMetadata, TreePath> hint2Path = new HashMap<HintMetadata, TreePath>();

    HintsPanel(final @NullAllowed OptionsFilter filter, final @NullAllowed HintsSettings overlay) {
        this.cpBased = null;
        this.queryStatus = QueryStatus.SHOW_QUERIES;
        this.showHeavyInspections = false;
        WORKER.post(new Runnable(){

            @Override
            public void run() {
                RulesManager.getInstance();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HintsPanel.this.removeAll();
                        HintsPanel.this.init(filter, false, overlay != null, true, true, true, true, false);
                        if (overlay != null) {
                            HintsPanel.this.setOverlayPreferences(overlay, false);
                        }
                        HintsPanel.this.buttonsPanel.setVisible(false);
                        HintsPanel.this.searchPanel.setVisible(false);
                        HintsPanel.this.configurationsPanel.setVisible(false);
                    }
                });
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(Bundle.LBL_Loading()), new GridBagConstraints());
    }

    public HintsPanel(Configuration preselected, Utilities.ClassPathBasedHintWrapper cpBased) {
        this.cpBased = cpBased;
        this.queryStatus = QueryStatus.ONLY_ENABLED;
        this.showHeavyInspections = true;
        this.init(null, true, false, false, true, true, true, false);
        this.configCombo.setSelectedItem(preselected);
    }

    public HintsPanel(HintMetadata preselected, final @NullAllowed Analyzer.CustomizerContext<?, ?> cc, Utilities.ClassPathBasedHintWrapper cpBased) {
        this.cpBased = cpBased;
        this.queryStatus = cc == null ? QueryStatus.NEVER : QueryStatus.SHOW_QUERIES;
        this.showHeavyInspections = true;
        this.init(null, true, false, false, false, cc == null, false, cc != null);
        this.select(preselected);
        this.configurationsPanel.setVisible(false);
        if (cc != null) {
            this.errorTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    HintMetadata hm = HintsPanel.this.getSelectedHint();
                    if (hm != null) {
                        cc.setSelectedId("text/x-java:" + hm.id);
                    }
                }
            });
        }
    }

    public HintsPanel(Preferences configurations, Utilities.ClassPathBasedHintWrapper cpBased, boolean direct) {
        this.cpBased = cpBased;
        this.queryStatus = QueryStatus.SHOW_QUERIES;
        this.showHeavyInspections = true;
        this.init(null, true, false, false, false, false, true, direct);
        this.setOverlayPreferences(HintsSettings.createPreferencesBasedHintsSettings((Preferences)configurations, (boolean)false, (Severity)Severity.VERIFIER), direct);
        this.configurationsPanel.setVisible(false);
    }

    public void setOverlayPreferences(HintsSettings configurations, boolean direct) {
        if (this.logic != null) {
            this.logic.setOverlayPreferences(configurations, direct);
        }
    }

    public boolean hasNewHints() {
        return this.hasNewHints;
    }

    private void setModel(DefaultTreeModel errorTreeModel) {
        if (this.optionsFilter != null) {
            this.optionsFilter.installFilteringModel(this.errorTree, (TreeModel)errorTreeModel, (OptionsFilter.Acceptor)new AcceptorImpl());
        } else {
            this.errorTree.setModel(errorTreeModel);
        }
    }

    private void init(@NullAllowed OptionsFilter filter, boolean batchOnly, boolean filterSuggestions, boolean ignoreMissingFilter, boolean showSeverityCombo, boolean showOkCancel, boolean showCheckBoxes, boolean direct) {
        this.initComponents();
        this.updateEnabledState();
        this.scriptScrollPane.setVisible(false);
        this.optionsFilter = null;
        if (!ignoreMissingFilter && filter == null) {
            this.optionsFilter = OptionsFilter.create((Document)this.searchTextField.getDocument(), (Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        this.configCombo.setModel(new ConfigurationsComboModel(true));
        this.configCombo.setRenderer(new ConfigurationRenderer());
        this.configCombo.setSelectedItem(null);
        this.descriptionTextArea.setContentType("text/html");
        this.descriptionTextArea.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.scriptTextArea.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-javahints"));
        this.scriptTextArea.setEditable(true);
        this.errorTree.setCellRenderer(showCheckBoxes ? new CheckBoxRenderer() : new JLabelRenderer());
        this.errorTree.setRootVisible(false);
        this.errorTree.setShowsRootHandles(true);
        this.errorTree.getSelectionModel().setSelectionMode(1);
        this.errorTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.handleClick(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handleClick(e);
            }

            private void handleClick(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DefaultMutableTreeNode o;
                    Point p = e.getPoint();
                    TreePath path = HintsPanel.this.errorTree.getPathForLocation(e.getPoint().x, e.getPoint().y);
                    if (path != null && (o = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof HintMetadata) {
                        HintMetadata hint = (HintMetadata)o.getUserObject();
                        if (hint.category.equals("custom")) {
                            JPopupMenu popup = new JPopupMenu();
                            popup.add(new JMenuItem(new RenameHint(o, hint, path)));
                            popup.add(new JMenuItem(new RemoveHint(o, hint)));
                            popup.show(HintsPanel.this.errorTree, e.getX(), e.getY());
                        }
                    }
                }
            }
        });
        this.errorTree.getInputMap().put(KeyStroke.getKeyStroke(127, 0), DELETE);
        this.errorTree.getActionMap().put(DELETE, new RemoveHint(null, null));
        this.toProblemCheckBox.setVisible(false);
        Set<? extends HintMetadata> hints = !batchOnly ? this.filterCustom(RulesManager.getInstance().readHints(null, null, null).keySet(), filterSuggestions) : Utilities.getBatchSupportedHints(this.cpBased).keySet();
        this.errorTreeModel = this.constructTM(hints, !batchOnly && !filterSuggestions);
        if (filter != null) {
            filter.installFilteringModel(this.errorTree, (TreeModel)this.errorTreeModel, (OptionsFilter.Acceptor)new AcceptorImpl());
        } else {
            this.setModel(this.errorTreeModel);
        }
        this.initialized.set(true);
        this.update(direct);
        if (this.toSelect != null) {
            this.select(this.toSelect, true);
            this.toSelect = null;
        }
        boolean editEnabled = showOkCancel && FileUtil.getConfigFile((String)DECLARATIVE_HINT_TEMPLATE_LOCATION) != null;
        this.newButton.setVisible(editEnabled);
        this.importButton.setVisible(false);
        this.exportButton.setVisible(false);
        this.editScriptButton.setVisible(editEnabled);
        this.editingButtons.setVisible(false);
        this.severityComboBox.setVisible(showSeverityCombo);
        this.severityLabel.setVisible(showSeverityCombo);
        this.okButton.setVisible(showOkCancel);
        this.cancelButton.setVisible(showOkCancel);
        this.validate();
    }

    private void updateEnabledState() {
        boolean enabled = this.isEnabled();
        this.enableDisableRecursively(this, enabled);
    }

    private void enableDisableRecursively(Component what, boolean enable) {
        what.setEnabled(enable);
        if (what instanceof Container) {
            for (Component c : ((Container)what).getComponents()) {
                this.enableDisableRecursively(c, enable);
            }
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.treePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.errorTree = new EditableJTree();
        this.detailsPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.severityLabel = new JLabel();
        this.severityComboBox = new JComboBox();
        this.toProblemCheckBox = new JCheckBox();
        this.customizerPanel = new JPanel();
        this.descriptionPanel = new JPanel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextArea = new JEditorPane();
        this.descriptionLabel = new JLabel();
        this.editingButtons = new JPanel();
        this.saveButton = new JButton();
        this.cancelEdit = new JButton();
        this.openInEditor = new JButton();
        this.scriptScrollPane = new JScrollPane();
        this.scriptTextArea = new JEditorPane();
        this.buttonsPanel = new JPanel();
        this.newButton = new JButton();
        this.importButton = new JButton();
        this.exportButton = new JButton();
        this.okButton = new JButton();
        this.editScriptButton = new JButton();
        this.cancelButton = new JButton();
        this.configurationsPanel = new JPanel();
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.searchPanel = new JPanel();
        this.refactoringsLabel = new JLabel();
        this.searchLabel = new JLabel();
        this.searchTextField = new JTextField();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(260);
        this.treePanel.setOpaque(false);
        this.treePanel.setLayout(new BorderLayout());
        this.errorTree.setEditable(true);
        this.jScrollPane1.setViewportView(this.errorTree);
        this.errorTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.errorTree.AccessibleContext.accessibleName"));
        this.errorTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.errorTree.AccessibleContext.accessibleDescription"));
        this.treePanel.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.treePanel);
        this.detailsPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.detailsPanel.setOpaque(false);
        this.optionsPanel.setOpaque(false);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.severityLabel.setLabelFor(this.severityComboBox);
        Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_ShowAs_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.optionsPanel.add((Component)this.severityLabel, gridBagConstraints);
        this.severityLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.severityLabel.AccessibleContext.accessibleDescription"));
        this.severityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.optionsPanel.add((Component)this.severityComboBox, new GridBagConstraints());
        this.severityComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"AN_Show_As_Combo"));
        this.severityComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"AD_Show_As_Combo"));
        Mnemonics.setLocalizedText((AbstractButton)this.toProblemCheckBox, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_InTasklist_CheckBox"));
        this.toProblemCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.optionsPanel.add((Component)this.toProblemCheckBox, gridBagConstraints);
        this.customizerPanel.setOpaque(false);
        this.customizerPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.optionsPanel.add((Component)this.customizerPanel, gridBagConstraints);
        this.descriptionPanel.setOpaque(false);
        this.descriptionPanel.setLayout(new GridBagLayout());
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setPreferredSize(new Dimension(100, 50));
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.descriptionPanel.add((Component)this.descriptionScrollPane, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.descriptionTextArea);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_Description_Border"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.descriptionPanel.add((Component)this.descriptionLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.saveButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.saveButton.text"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.saveButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cancelEdit, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.cancelEdit.text"));
        this.cancelEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.cancelEditActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.openInEditor, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.openInEditor.text"));
        this.openInEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.openInEditorActionPerformed(evt);
            }
        });
        GroupLayout editingButtonsLayout = new GroupLayout(this.editingButtons);
        this.editingButtons.setLayout(editingButtonsLayout);
        editingButtonsLayout.setHorizontalGroup(editingButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, editingButtonsLayout.createSequentialGroup().addComponent(this.openInEditor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 272, Short.MAX_VALUE).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelEdit)));
        editingButtonsLayout.setVerticalGroup(editingButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editingButtonsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.openInEditor).addComponent(this.cancelEdit).addComponent(this.saveButton)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.descriptionPanel.add((Component)this.editingButtons, gridBagConstraints);
        this.scriptTextArea.setEditable(false);
        this.scriptTextArea.setPreferredSize(new Dimension(100, 50));
        this.scriptScrollPane.setViewportView(this.scriptTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.descriptionPanel.add((Component)this.scriptScrollPane, gridBagConstraints);
        GroupLayout detailsPanelLayout = new GroupLayout(this.detailsPanel);
        this.detailsPanel.setLayout(detailsPanelLayout);
        detailsPanelLayout.setHorizontalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.descriptionPanel, -1, -1, Short.MAX_VALUE));
        detailsPanelLayout.setVerticalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addComponent(this.optionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.descriptionPanel, -1, 314, Short.MAX_VALUE)));
        this.jSplitPane1.setRightComponent(this.detailsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.newButton.text"));
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.newButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.importButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.importButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.exportButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.exportButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.okButton.text"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.okButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editScriptButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.editScriptButton.text"));
        this.editScriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.editScriptButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonsPanelLayout = new GroupLayout(this.buttonsPanel);
        this.buttonsPanel.setLayout(buttonsPanelLayout);
        buttonsPanelLayout.setHorizontalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonsPanelLayout.createSequentialGroup().addComponent(this.newButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exportButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 292, Short.MAX_VALUE).addComponent(this.editScriptButton).addGap(35, 35, 35).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)));
        buttonsPanelLayout.setVerticalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonsPanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newButton).addComponent(this.importButton).addComponent(this.exportButton).addComponent(this.editScriptButton).addComponent(this.cancelButton).addComponent(this.okButton))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.buttonsPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.configLabel.text"));
        this.configCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HintsPanel.this.configComboActionPerformed(evt);
            }
        });
        GroupLayout configurationsPanelLayout = new GroupLayout(this.configurationsPanel);
        this.configurationsPanel.setLayout(configurationsPanelLayout);
        configurationsPanelLayout.setHorizontalGroup(configurationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(configurationsPanelLayout.createSequentialGroup().addComponent(this.configLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configCombo, 0, 719, Short.MAX_VALUE)));
        configurationsPanelLayout.setVerticalGroup(configurationsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(configurationsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configLabel).addComponent(this.configCombo, -2, -1, -2)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.configurationsPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.refactoringsLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.refactoringsLabel.text"));
        this.searchLabel.setLabelFor(this.searchTextField);
        Mnemonics.setLocalizedText((JLabel)this.searchLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.searchLabel.text"));
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, searchPanelLayout.createSequentialGroup().addComponent(this.refactoringsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 576, Short.MAX_VALUE).addComponent(this.searchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchTextField, -2, 121, -2)));
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchTextField, -2, -1, -2).addComponent(this.searchLabel).addComponent(this.refactoringsLabel))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.searchPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.AccessibleContext.accessibleDescription"));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.applyChanges();
        this.confirmed = true;
        this.getRootPane().getParent().setVisible(false);
    }

    private void configComboActionPerformed(ActionEvent evt) {
        if (this.configCombo.getSelectedItem() instanceof ActionListener) {
            ((ActionListener)this.configCombo.getSelectedItem()).actionPerformed(evt);
        }
        if (this.queryStatus == QueryStatus.ONLY_ENABLED) {
            this.errorTreeModel = this.constructTM(Utilities.getBatchSupportedHints(this.cpBased).keySet(), false);
            this.setModel(this.errorTreeModel);
            if (this.logic != null) {
                this.logic.errorTreeModel = this.errorTreeModel;
            }
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        try {
            FileObject tempFO = FileUtil.getConfigFile((String)DECLARATIVE_HINT_TEMPLATE_LOCATION);
            FileObject folderFO = FileUtil.getConfigFile((String)"rules");
            if (folderFO == null) {
                folderFO = FileUtil.getConfigRoot().createFolder("rules");
            }
            DataFolder folder = (DataFolder)DataObject.find((FileObject)folderFO);
            DataObject template = DataObject.find((FileObject)tempFO);
            DataObject newIfcDO = template.createFromTemplate(folder, null);
            RulesManager.getInstance().reload();
            this.cpBased.reset();
            this.errorTreeModel = this.constructTM(Utilities.getBatchSupportedHints(this.cpBased).keySet(), false);
            this.setModel(this.errorTreeModel);
            this.logic.errorTreeModel = this.errorTreeModel;
            HintMetadata newHint = this.getHintByName(newIfcDO.getPrimaryFile().getNameExt());
            this.logic.writableSettings.setEnabled(newHint, true);
            this.select(newHint);
            this.hasNewHints = true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editScriptButtonActionPerformed(ActionEvent evt) {
        this.descriptionScrollPane.setVisible(false);
        this.scriptScrollPane.setVisible(true);
        this.editScriptButton.setVisible(false);
        this.editingButtons.setVisible(true);
        this.optionsPanel.setVisible(false);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_Script_Border"));
        DataObject dob = this.getDataObject(this.getSelectedHint());
        EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        try {
            final StyledDocument doc = ec.openDocument();
            doc.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        HintsPanel.this.customHintCodeBeforeEditing = doc.getText(0, doc.getLength());
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        HintsPanel.this.customHintCodeBeforeEditing = null;
                    }
                }
            });
            this.wasModified = DataObject.getRegistry().getModifiedSet().contains(dob);
            this.scriptTextArea.setDocument(doc);
            UndoManager um = new UndoManager();
            doc.addUndoableEditListener(um);
            doc.putProperty(UndoManager.class, um);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.newButton.setEnabled(false);
        this.searchTextField.setEnabled(false);
        this.configCombo.setEnabled(false);
        this.errorTree.setEnabled(false);
        this.okButton.setEnabled(false);
        this.validate();
    }

    private void cancelEditActionPerformed(ActionEvent evt) {
        this.descriptionScrollPane.setVisible(true);
        this.scriptScrollPane.setVisible(false);
        this.optionsPanel.setVisible(true);
        this.editingButtons.setVisible(false);
        this.editScriptButton.setVisible(true);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_Description_Border"));
        if (this.customHintCodeBeforeEditing != null) {
            DataObject dob = this.getDataObject(this.getSelectedHint());
            EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
            try {
                final StyledDocument doc = ec.openDocument();
                NbDocument.runAtomic((StyledDocument)doc, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            doc.remove(0, doc.getLength());
                            doc.insertString(0, HintsPanel.this.customHintCodeBeforeEditing, null);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
                this.customHintCodeBeforeEditing = null;
                if (!this.wasModified) {
                    ec.saveDocument();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.okButton.setEnabled(true);
        this.newButton.setEnabled(true);
        this.searchTextField.setEnabled(true);
        this.configCombo.setEnabled(true);
        this.errorTree.setEnabled(true);
        this.logic.valueChanged(null);
    }

    private void openInEditorActionPerformed(ActionEvent evt) {
        this.applyChanges();
        this.getRootPane().getParent().getParent().setVisible(false);
        DataObject dob = this.getDataObject(this.getSelectedHint());
        EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        ec.open();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        HintMetadata selectedHint = this.getSelectedHint();
        String selectedHintId = selectedHint.id;
        DataObject dob = this.getDataObject(selectedHint);
        EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        try {
            ec.saveDocument();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        RulesManager.getInstance().reload();
        this.cpBased.reset();
        this.errorTreeModel = this.constructTM(Utilities.getBatchSupportedHints(this.cpBased).keySet(), false);
        this.setModel(this.errorTreeModel);
        if (this.logic != null) {
            this.logic.errorTreeModel = this.errorTreeModel;
        }
        this.select(this.getHintByName(selectedHintId));
        this.customHintCodeBeforeEditing = null;
        this.cancelEditActionPerformed(evt);
        this.hasNewHints = true;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.getRootPane().getParent().setVisible(false);
    }

    private HintMetadata getHintByName(String name) {
        for (HintMetadata hintMetadata : Utilities.getBatchSupportedHints(this.cpBased).keySet()) {
            if (!hintMetadata.id.startsWith(name)) continue;
            return hintMetadata;
        }
        return null;
    }

    synchronized void update(boolean direct) {
        if (!this.initialized.get()) {
            return;
        }
        HintsSettings overlay = null;
        if (this.logic != null) {
            this.logic.disconnect();
            overlay = this.logic.getOverlayPreferences();
        }
        this.logic = new HintsPanelLogic();
        this.logic.connect(this.errorTree, this.errorTreeModel, this.severityLabel, this.severityComboBox, this.toProblemCheckBox, this.customizerPanel, this.descriptionTextArea, this.configCombo, this.editScriptButton, overlay, direct);
    }

    synchronized void cancel() {
        if (this.logic == null || !this.initialized.get()) {
            return;
        }
        this.logic.disconnect();
        this.logic = null;
    }

    boolean isChanged() {
        return this.logic != null ? this.logic.isChanged() : false;
    }

    public void applyChanges() {
        if (!this.initialized.get()) {
            return;
        }
        this.logic.applyChanges();
        this.logic.disconnect();
        this.logic = null;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    private DefaultTreeModel constructTM(Collection<? extends HintMetadata> metadata, boolean allHints) {
        HintsPanelLogic.HintCategory rootCategory = new HintsPanelLogic.HintCategory("");
        for (HintMetadata hintMetadata : metadata) {
            if (hintMetadata.options.contains(HintMetadata.Options.NON_GUI) || hintMetadata.options.contains(HintMetadata.Options.HEAVY) && !this.showHeavyInspections || hintMetadata.options.contains(HintMetadata.Options.QUERY) && !"custom".equals(hintMetadata.category) && (this.queryStatus == QueryStatus.NEVER || this.queryStatus == QueryStatus.ONLY_ENABLED && this.logic != null && !this.logic.isEnabled(hintMetadata))) continue;
            HintsPanelLogic.HintCategory curr = rootCategory;
            int lastIndex = -1;
            boolean stop = false;
            block1: do {
                int newIndex;
                if ((newIndex = hintMetadata.category.indexOf(47, lastIndex + 1)) == -1) {
                    newIndex = hintMetadata.category.length();
                    stop = true;
                }
                lastIndex = newIndex;
                String currentCategory = hintMetadata.category.substring(0, newIndex);
                for (HintsPanelLogic.HintCategory hc : curr.subCategories) {
                    if (!currentCategory.equals(hc.codeName)) continue;
                    curr = hc;
                    continue block1;
                }
                curr = new HintsPanelLogic.HintCategory(currentCategory);
                curr.subCategories.add(curr);
            } while (!stop);
            curr.hints.add(hintMetadata);
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        IdentityHashMap<HintsPanelLogic.HintCategory, TreePath> identityHashMap = new IdentityHashMap<HintsPanelLogic.HintCategory, TreePath>();
        identityHashMap.put(rootCategory, new TreePath(root));
        LinkedList<HintsPanelLogic.HintCategory> hints = new LinkedList<HintsPanelLogic.HintCategory>();
        hints.add(rootCategory);
        while (!hints.isEmpty()) {
            HintsPanelLogic.HintCategory cat = (HintsPanelLogic.HintCategory)hints.remove(0);
            TreePath currentPath = (TreePath)identityHashMap.get(cat);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)currentPath.getLastPathComponent();
            cat.subCategories.sort(new Comparator<HintsPanelLogic.HintCategory>(){

                @Override
                public int compare(HintsPanelLogic.HintCategory o1, HintsPanelLogic.HintCategory o2) {
                    return HintsPanel.compare(o1.displayName, o2.displayName);
                }
            });
            for (HintsPanelLogic.HintCategory sub : cat.subCategories) {
                DefaultMutableTreeNode subNode = new DefaultMutableTreeNode(sub);
                identityHashMap.put(sub, currentPath.pathByAddingChild(subNode));
                node.add(subNode);
            }
            hints.addAll(cat.subCategories);
            cat.hints.sort(new Comparator<HintMetadata>(){

                @Override
                public int compare(HintMetadata o1, HintMetadata o2) {
                    return o1.displayName.compareTo(o2.displayName);
                }
            });
            for (HintMetadata hm : cat.hints) {
                DefaultMutableTreeNode hintNode = new DefaultMutableTreeNode(hm);
                node.add(hintNode);
                this.hint2Path.put(hm, currentPath.pathByAddingChild(hintNode));
            }
        }
        if (allHints) {
            root.add(this.extraNode);
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(root){

            @Override
            public void valueForPathChanged(TreePath path, Object newValue) {
                DefaultMutableTreeNode o = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (o.getUserObject() instanceof HintMetadata) {
                    try {
                        HintMetadata hint = (HintMetadata)o.getUserObject();
                        HintsPanel.this.getDataObject(hint).rename((String)newValue);
                        RulesManager.getInstance().reload();
                        HintsPanel.this.cpBased.reset();
                        HintsPanel.this.errorTreeModel = HintsPanel.this.constructTM(Utilities.getBatchSupportedHints(HintsPanel.this.cpBased).keySet(), false);
                        HintsPanel.this.setModel(HintsPanel.this.errorTreeModel);
                        if (HintsPanel.this.logic != null) {
                            HintsPanel.this.logic.errorTreeModel = HintsPanel.this.errorTreeModel;
                        }
                        HintsPanel.this.select(HintsPanel.this.getHintByName((String)newValue));
                        HintsPanel.this.hasNewHints = true;
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(HintsPanel.this.errorTree, NbBundle.getMessage(HintsPanel.class, (String)"ERR_CannotRename", (Object)newValue));
                        HintsPanel.this.errorTree.startEditingAtPath(path);
                    }
                }
            }
        };
        return defaultTreeModel;
    }

    public void select(HintMetadata hm) {
        this.select(hm, false);
    }

    public void select(HintMetadata hm, boolean setFocus) {
        if (this.errorTree == null) {
            this.toSelect = hm;
            return;
        }
        TreePath path = this.hint2Path.get(hm);
        if (path == null) {
            return;
        }
        this.errorTree.setSelectionPath(path);
        this.errorTree.scrollPathToVisible(path);
        if (setFocus) {
            this.errorTree.requestFocusInWindow();
        }
    }

    private static int compare(String s1, String s2) {
        return HintsPanel.clearNonAlpha(s1).compareToIgnoreCase(HintsPanel.clearNonAlpha(s2));
    }

    private static String clearNonAlpha(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        for (char c : str.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private DataObject getDataObject(HintMetadata selectedHint) {
        String fileName = selectedHint.id.indexOf(45) != -1 ? selectedHint.id.substring(0, selectedHint.id.lastIndexOf(45)) : selectedHint.id;
        FileObject fo = FileUtil.getConfigFile((String)("rules/" + fileName));
        try {
            return fo == null ? null : DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private Collection<? extends HintMetadata> filterCustom(Set<HintMetadata> keySet, boolean filterSuggestions) {
        ArrayList<HintMetadata> list = new ArrayList<HintMetadata>();
        for (HintMetadata hint : keySet) {
            if (hint.kind == Hint.Kind.ACTION && filterSuggestions) continue;
            list.add(hint);
        }
        return list;
    }

    public Configuration getSelectedConfiguration() {
        return (Configuration)this.configCombo.getSelectedItem();
    }

    public HintMetadata getSelectedHint() {
        TreePath selectionPath = this.errorTree.getSelectionModel().getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)((MutableTreeNode)((TreeNode)selectionPath.getLastPathComponent()));
        if (lastPathComponent != null && lastPathComponent.getUserObject() instanceof HintMetadata) {
            return (HintMetadata)lastPathComponent.getUserObject();
        }
        return null;
    }

    private static enum QueryStatus {
        SHOW_QUERIES,
        ONLY_ENABLED,
        NEVER;

    }

    private final class AcceptorImpl
    implements OptionsFilter.Acceptor {
        private AcceptorImpl() {
        }

        public boolean accept(Object originalTreeNode, String filterText) {
            if (filterText.isEmpty()) {
                return true;
            }
            HintsPanel.this.expandTask.schedule(100);
            if (originalTreeNode == HintsPanel.this.extraNode) {
                for (String key : EXTRA_NODE_KEYWORDS) {
                    if (!NbBundle.getMessage(HintsPanel.class, (String)key).toLowerCase().contains(filterText)) continue;
                    return true;
                }
                return false;
            }
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)originalTreeNode;
            Object uo = n.getUserObject();
            if (!(uo instanceof HintMetadata)) {
                return false;
            }
            HintMetadata hm = (HintMetadata)uo;
            filterText = filterText.toLowerCase();
            if (hm.displayName.toLowerCase().contains(filterText)) {
                return true;
            }
            if (hm.description.toLowerCase().contains(filterText)) {
                return true;
            }
            for (String sw : hm.suppressWarnings) {
                if (!sw.toLowerCase().contains(filterText)) continue;
                return true;
            }
            return false;
        }
    }

    class CheckBoxRenderer
    implements TreeCellRenderer {
        private final TristateCheckBox renderer = new TristateCheckBox();
        private final DefaultTreeCellRenderer dr = new DefaultTreeCellRenderer();

        CheckBoxRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.renderer.setBackground(selected ? this.dr.getBackgroundSelectionColor() : this.dr.getBackgroundNonSelectionColor());
            this.renderer.setForeground(selected ? this.dr.getTextSelectionColor() : this.dr.getTextNonSelectionColor());
            this.renderer.setFont(this.renderer.getFont().deriveFont(0));
            this.renderer.setEnabled(tree.isEnabled());
            Object data = ((DefaultMutableTreeNode)value).getUserObject();
            if (data instanceof HintsPanelLogic.HintCategory) {
                HintsPanelLogic.HintCategory cat = (HintsPanelLogic.HintCategory)data;
                this.renderer.setText(cat.displayName);
                if (HintsPanel.this.logic != null) {
                    this.renderer.setState(HintsPanel.this.logic.isSelected((DefaultMutableTreeNode)value));
                }
            } else if (data instanceof HintMetadata) {
                HintMetadata treeRule = (HintMetadata)data;
                if (treeRule.options.contains(HintMetadata.Options.QUERY)) {
                    this.renderer.setFont(this.renderer.getFont().deriveFont(2));
                }
                this.renderer.setText(treeRule.displayName);
                if (HintsPanel.this.logic != null) {
                    this.renderer.setSelected(HintsPanel.this.logic.isEnabled(treeRule));
                }
            } else {
                this.renderer.setText(value.toString());
                if (value == HintsPanel.this.extraNode && HintsPanel.this.logic != null) {
                    this.renderer.setSelected(HintsPanel.this.logic.getCurrentDependencyTracking() != DepScanningSettings.DependencyTracking.DISABLED);
                }
            }
            return this.renderer;
        }
    }

    class JLabelRenderer
    implements TreeCellRenderer {
        private JLabel renderer = new JLabel();
        private DefaultTreeCellRenderer dr = new DefaultTreeCellRenderer();

        JLabelRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.renderer.setBackground(selected ? this.dr.getBackgroundSelectionColor() : this.dr.getBackgroundNonSelectionColor());
            this.renderer.setForeground(selected ? this.dr.getTextSelectionColor() : this.dr.getTextNonSelectionColor());
            this.renderer.setFont(this.renderer.getFont().deriveFont(0));
            this.renderer.setOpaque(true);
            this.renderer.setEnabled(tree.isEnabled());
            Object data = ((DefaultMutableTreeNode)value).getUserObject();
            if (data instanceof HintsPanelLogic.HintCategory) {
                HintsPanelLogic.HintCategory cat = (HintsPanelLogic.HintCategory)data;
                this.renderer.setText(cat.displayName);
            } else if (data instanceof HintMetadata) {
                HintMetadata treeRule = (HintMetadata)data;
                if (treeRule.options.contains(HintMetadata.Options.QUERY)) {
                    this.renderer.setFont(this.renderer.getFont().deriveFont(2));
                }
                this.renderer.setText(treeRule.displayName);
            } else {
                this.renderer.setText(value.toString());
            }
            return this.renderer;
        }
    }

    private class RemoveHint
    extends AbstractAction {
        HintMetadata hint;
        DefaultMutableTreeNode node;

        public RemoveHint(DefaultMutableTreeNode node, HintMetadata hint) {
            super(NbBundle.getMessage(RemoveHint.class, (String)"CTL_Delete"));
            this.hint = hint;
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HintMetadata hint = this.hint;
            try {
                if (hint == null) {
                    hint = HintsPanel.this.getSelectedHint();
                }
                if (hint == null) {
                    return;
                }
                DataObject d = HintsPanel.this.getDataObject(hint);
                if (d == null) {
                    return;
                }
                if (0 == JOptionPane.showConfirmDialog(HintsPanel.this.errorTree, NbBundle.getMessage(HintsPanel.class, (String)"MSG_DeleteConfirmMessage", (Object)hint.displayName), NbBundle.getMessage(HintsPanel.class, (String)"MSG_DeleteConfirmTitle"), 0)) {
                    d.delete();
                    RulesManager.getInstance().reload();
                    HintsPanel.this.cpBased.reset();
                    HintsPanel.this.errorTreeModel = HintsPanel.this.constructTM(Utilities.getBatchSupportedHints(HintsPanel.this.cpBased).keySet(), false);
                    HintsPanel.this.setModel(HintsPanel.this.errorTreeModel);
                    if (HintsPanel.this.logic != null) {
                        HintsPanel.this.logic.errorTreeModel = HintsPanel.this.errorTreeModel;
                    }
                    HintsPanel.this.hasNewHints = true;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class EditableJTree
    extends JTree {
        @Override
        public boolean isPathEditable(TreePath path) {
            DefaultMutableTreeNode o = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (o.getUserObject() instanceof HintMetadata) {
                HintMetadata hint = (HintMetadata)o.getUserObject();
                if (hint.category.equals("custom")) {
                    return true;
                }
            }
            return false;
        }
    }

    private class RenameHint
    extends AbstractAction {
        HintMetadata hint;
        DefaultMutableTreeNode node;
        TreePath path;

        public RenameHint(DefaultMutableTreeNode node, HintMetadata hint, TreePath path) {
            super(NbBundle.getMessage(RemoveHint.class, (String)"CTL_Rename"));
            this.hint = hint;
            this.node = node;
            this.path = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HintsPanel.this.errorTree.startEditingAtPath(this.path);
        }
    }

    private static class TristateCheckBox
    extends JCheckBox {
        private final TristateDecorator model = new TristateDecorator(this.getModel());

        public TristateCheckBox() {
            super(null, null);
            this.setModel(this.model);
            this.setState(State.OTHER);
        }

        @Override
        public void addMouseListener(MouseListener l) {
        }

        public void setState(State state) {
            this.model.setState(state);
        }

        public State getState() {
            return this.model.getState();
        }

        @Override
        public void setSelected(boolean b) {
            if (b) {
                this.setState(State.SELECTED);
            } else {
                this.setState(State.NOT_SELECTED);
            }
        }

        private class TristateDecorator
        implements ButtonModel {
            private final ButtonModel other;

            private TristateDecorator(ButtonModel other) {
                this.other = other;
            }

            private void setState(State state) {
                if (state == State.NOT_SELECTED) {
                    this.other.setArmed(false);
                    this.setPressed(false);
                    this.setSelected(false);
                } else if (state == State.SELECTED) {
                    this.other.setArmed(false);
                    this.setPressed(false);
                    this.setSelected(true);
                } else {
                    this.other.setArmed(true);
                    this.setPressed(true);
                    this.setSelected(true);
                }
            }

            private State getState() {
                if (this.isSelected() && !this.isArmed()) {
                    return State.SELECTED;
                }
                if (this.isSelected() && this.isArmed()) {
                    return State.OTHER;
                }
                return State.NOT_SELECTED;
            }

            @Override
            public void setArmed(boolean b) {
            }

            @Override
            public void setEnabled(boolean b) {
                TristateCheckBox.this.setFocusable(b);
                this.other.setEnabled(b);
            }

            @Override
            public boolean isArmed() {
                return this.other.isArmed();
            }

            @Override
            public boolean isSelected() {
                return this.other.isSelected();
            }

            @Override
            public boolean isEnabled() {
                return this.other.isEnabled();
            }

            @Override
            public boolean isPressed() {
                return this.other.isPressed();
            }

            @Override
            public boolean isRollover() {
                return this.other.isRollover();
            }

            @Override
            public void setSelected(boolean b) {
                this.other.setSelected(b);
            }

            @Override
            public void setPressed(boolean b) {
                this.other.setPressed(b);
            }

            @Override
            public void setRollover(boolean b) {
                this.other.setRollover(b);
            }

            @Override
            public void setMnemonic(int key) {
                this.other.setMnemonic(key);
            }

            @Override
            public int getMnemonic() {
                return this.other.getMnemonic();
            }

            @Override
            public void setActionCommand(String s) {
                this.other.setActionCommand(s);
            }

            @Override
            public String getActionCommand() {
                return this.other.getActionCommand();
            }

            @Override
            public void setGroup(ButtonGroup group) {
                this.other.setGroup(group);
            }

            @Override
            public void addActionListener(ActionListener l) {
                this.other.addActionListener(l);
            }

            @Override
            public void removeActionListener(ActionListener l) {
                this.other.removeActionListener(l);
            }

            @Override
            public void addItemListener(ItemListener l) {
                this.other.addItemListener(l);
            }

            @Override
            public void removeItemListener(ItemListener l) {
                this.other.removeItemListener(l);
            }

            @Override
            public void addChangeListener(ChangeListener l) {
                this.other.addChangeListener(l);
            }

            @Override
            public void removeChangeListener(ChangeListener l) {
                this.other.removeChangeListener(l);
            }

            @Override
            public Object[] getSelectedObjects() {
                return this.other.getSelectedObjects();
            }
        }
    }

    static enum State {
        SELECTED,
        NOT_SELECTED,
        OTHER;

    }
}

